{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:18:31 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Wintypes,
  WinProcs,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  MMSystem,
  MMObj,
  MMUtils,
  MMRegs,
  MMDesign,
  MMWave,
  MMConect,
  MMFXGen,
  MMDSPObj,
  MMWavOut,
  MMSpectr,
  MMDIBCv,
  MMOscope,
  MMSlider,
  MMLEDS,
  MMSwitch,
  MMHook;

type
  TMainForm = class(TForm)
    MMWaveOut1: TMMWaveOut;
    MMGenerator1: TMMGenerator;
    MMConnector1: TMMConnector;
    ckbFile: TCheckBox;
    GroupBox1: TGroupBox;
    Kind: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    MMSwitch1: TMMSwitch;
    MMSwitch2: TMMSwitch;
    MMLEDSpin2: TMMLEDSpin;
    MMLEDSpin3: TMMLEDSpin;
    ckBShowPeak: TCheckBox;
    GroupBox2: TGroupBox;
    Panel1: TPanel;
    MMOscope1: TMMOscope;
    MMSpectrum1: TMMSpectrum;
    MMWaveFile1: TMMWaveFile;
    Label37: TLabel;
    Label38: TLabel;
    StartButton: TButton;
    StopButton: TButton;
    ExitButton: TButton;
    sliderFreq3: TMMSlider;
    SpinFreq3: TMMLEDSpin;
    Label36: TLabel;
    lblPeak: TLabel;
    sliderAmp3: TMMSlider;
    Panel2: TPanel;
    Label19: TLabel;
    switchWave3: TMMSwitch;
    SpinFreq1: TMMLEDSpin;
    sliderFreq1: TMMSlider;
    sliderAmp1: TMMSlider;
    MMGenerator2: TMMGenerator;
    Label17: TLabel;
    Label18: TLabel;
    Label21: TLabel;
    switchWave1: TMMSwitch;
    CheckBEnabled3: TCheckBox;
    CheckBEnabled2: TCheckBox;
    SpinFreq2: TMMLEDSpin;
    sliderFreq2: TMMSlider;
    Label16: TLabel;
    sliderAmp2: TMMSlider;
    Label22: TLabel;
    SwitchWave2: TMMSwitch;
    SliderAMFM3: TMMSlider;
    SliderAMFM2: TMMSlider;
    Label24: TLabel;
    Label25: TLabel;
    CheckBEnabled1: TCheckBox;
    Label20: TLabel;
    Label23: TLabel;
    Label26: TLabel;
    MMGenerator3: TMMGenerator;
    MMDesigner1: TMMDesigner;
    procedure StartButtonClick(Sender: TObject);
    procedure MMWaveOut1BufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure StopButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure sliderFreqChange(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure MMSpin2DownClick(Sender: TObject);
    procedure MMSpin2UpClick(Sender: TObject);
    procedure MMSwitch2Change(Sender: TObject);
    procedure MMSpin3DownClick(Sender: TObject);
    procedure MMSpin3UpClick(Sender: TObject);
    procedure MMSwitch1Change(Sender: TObject);
    procedure ckBShowPeakClick(Sender: TObject);
    procedure SpinFreqChange(Sender: TObject);
    procedure sliderAmpChange(Sender: TObject);
    procedure switchWaveChange(Sender: TObject);
    procedure CheckBEnabledClick(Sender: TObject);
    procedure SliderAMFMChange(Sender: TObject);
    procedure ckbFileClick(Sender: TObject);
    procedure MMWaveOut1BufferFilled(Sender: TObject; lpWaveHdr: PWaveHdr);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.StartButtonClick(Sender: TObject);
begin
   if (MMWaveOut1.NumDevs = 0) then
       Application.MessageBox('Sorry, No WaveOut device installed!',
                              'WaveOut open error',mb_OK OR mb_IconStop)
   else if not (wosOpen in MMWaveOut1.State) then
   begin
      { start the output }
      MMWaveOut1.Start;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.StopButtonClick(Sender: TObject);
begin
   { stop and close the device }
   MMWaveOut1.Close;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ExitButtonClick(Sender: TObject);
begin
   Close;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveOut1BufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
var
   aPeak: TPeak;

begin
   aPeak := MMSpectrum1.Peak;
   with aPeak do
   lblPeak.Caption :=  Format(' Frequency: %7.1f Hz ',[Freq])+
                       Format(' %7.2f db ',[db]);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   { stop and close the device }
   MMWaveOut1.Close;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSwitch1Change(Sender: TObject);
begin
   MMSpectrum1.Kind := TMMSpectrumKind(MMSwitch1.Position);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSpin2UpClick(Sender: TObject);
begin
   MMSpectrum1.FFTLength := MMSpectrum1.FFTLength * 2;
   MMLEDSpin2.Value := MMSpectrum1.FFTLength;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSpin2DownClick(Sender: TObject);
begin
   MMSpectrum1.FFTLength := MMSpectrum1.FFTLength div 2;
   MMLEDSpin2.Value := MMSpectrum1.FFTLength;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSwitch2Change(Sender: TObject);
begin
   MMSpectrum1.Window := TMMFFTWindow(MMSwitch2.Position);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSpin3UpClick(Sender: TObject);
var
   Factor: integer;
begin
   if (MMSpectrum1.VerticalScale < 10) then Factor := 1
   else Factor := 10;

   MMSpectrum1.VerticalScale := MMSpectrum1.VerticalScale + Factor;
   MMLEDSpin3.Value := MMSpectrum1.VerticalScale;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSpin3DownClick(Sender: TObject);
var
   Factor: integer;
begin
   if (MMSpectrum1.VerticalScale > 10) then Factor := 10
   else Factor := 1;

   MMSpectrum1.VerticalScale := MMSpectrum1.VerticalScale - Factor;
   MMLEDSpin3.Value := MMSpectrum1.VerticalScale;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ckBShowPeakClick(Sender: TObject);
begin
   MMSpectrum1.DisplayPeak := ckBShowPeak.Checked;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ckbFileClick(Sender: TObject);
begin
   MMWaveFile1.Enabled := True;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.CheckBEnabledClick(Sender: TObject);
begin
   if (Sender = CheckBEnabled1) then
   begin
      MMGenerator1.Enabled := CheckBEnabled1.Checked;
   end
   else if (Sender = CheckBEnabled2) then
   begin
      MMGenerator2.Enabled := CheckBEnabled2.Checked;
   end
   else
   begin
      MMGenerator3.Enabled := CheckBEnabled3.Checked;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.sliderFreqChange(Sender: TObject);
begin
   if (Sender = sliderFreq1) then
   begin
      MMGenerator1.Frequency := sliderFreq1.Position;
      SpinFreq1.Value := Trunc(MMGenerator1.Frequency);
   end
   else if (Sender = sliderFreq2) then
   begin
      MMGenerator2.Frequency := sliderFreq2.Position;
      SpinFreq2.Value := Trunc(MMGenerator2.Frequency);
   end
   else
   begin
      MMGenerator3.Frequency := sliderFreq3.Position;
      SpinFreq3.Value := Trunc(MMGenerator3.Frequency);
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SpinFreqChange(Sender: TObject);
begin
   if (Sender = SpinFreq1) then
   begin
      MMGenerator1.Frequency := SpinFreq1.Value;
      SliderFreq1.Position := SpinFreq1.Value;
   end
   else if (Sender = SpinFreq2) then
   begin
      MMGenerator2.Frequency := SpinFreq2.Value;
      SliderFreq2.Position := SpinFreq2.Value;
   end
   else
   begin
      MMGenerator3.Frequency := SpinFreq3.Value;
      SliderFreq3.Position := SpinFreq3.Value;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.sliderAmpChange(Sender: TObject);
begin
   if (Sender = sliderAmp1) then
   begin
      MMGenerator1.Amplitude := SliderAmp1.Position;
   end
   else if (Sender = sliderAmp2) then
   begin
      MMGenerator2.Amplitude := SliderAmp2.Position;
   end
   else
   begin
      MMGenerator3.Amplitude := SliderAmp3.Position;
   end
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.switchWaveChange(Sender: TObject);
begin
   if (Sender = switchWave1) then
   begin
      MMGenerator1.WaveForm := TMMWaveForm(SwitchWave1.Position);
   end
   else if (Sender = switchWave2) then
   begin
      MMGenerator2.WaveForm := TMMWaveForm(SwitchWave2.Position);
   end
   else
   begin
      MMGenerator3.WaveForm := TMMWaveForm(SwitchWave3.Position);
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SliderAMFMChange(Sender: TObject);
begin
   if (Sender = sliderAMFM2) then
   begin
      MMGenerator2.Modulation := TMMModulation(SliderAMFM2.Position);
   end
   else
   begin
      MMGenerator3.Modulation := TMMModulation(SliderAMFM3.Position);
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveOut1BufferFilled(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   MMConnector1.Trigger;
end;

end.
